<?php

/* setup includes */
require_once('../../../core/includes/master.inc.php');

// require login
$Auth->requireUser(WEB_ROOT . '/login.' . SITE_CONFIG_PAGE_EXTENSION);

// prepare result
$result          = array();
$result['error'] = false;
$result['msg']   = 'Files moved.';

if (_CONFIG_DEMO_MODE == true)
{
    $result['error'] = true;
    $result['msg']   = t("no_changes_in_demo_mode");
}
elseif(corefunctions::getUsersAccountLockStatus($Auth->id) == 1)
{
    $result['error'] = true;
    $result['msg']   = t('account_locked_folder_edit_error_message', 'This account has been locked, please unlock the account to regain full functionality.');
}
else
{
    $folderId = NULL;

    // try to load the folder
    $fileFolder = fileFolder::loadById((int) $_REQUEST['folderId']);
    if ($fileFolder)
    {
        // make sure the current logged in user is the owner
        if ($fileFolder->userId == $Auth->id)
        {
            $folderId = (int) $fileFolder->id;
        }
        // if not, check to see if the current user has access rights
        else
        {
            $hasAccess = $db->getValue('SELECT id FROM file_folder_share WHERE folder_id = :folder_id AND shared_with_user_id = :shared_with_user_id AND share_permission_level IN ("all", "upload_download") LIMIT 1', array(
                'folder_id' => $fileFolder->id,
                'shared_with_user_id' => $Auth->id,
            ));
            if($hasAccess)
            {
                // user has write access
                $folderId = (int) $fileFolder->id;
            }
        }
    }

    if($folderId == NULL)
    {
        $result['error'] = true;
        $result['msg']   = t("move_file_in_folder_no_folder_access", "You do not have permission to upload to that folder.");
    }
    else
    {
        // update files
        $fileIds = $_REQUEST['fileIds'];
        if (COUNT($fileIds))
        {
            $filteredIds = array();
            foreach ($fileIds AS $fileId)
            {
                $filteredIds[] = (int) $fileId;
            }

            // load all original filenames to check for duplicates
            $files             = $db->getRows('SELECT originalFilename FROM file WHERE id IN (' . implode(',', $filteredIds) . ') AND (userId = ' . (int)$Auth->id.' OR file.uploadedUserId = '.(int)$Auth->id.')');
            $originalFilenames = array();
            foreach ($files AS $file)
            {
                $originalFilenames[] = $db->quote($file['originalFilename']);
            }

            // make sure files don;t exist already in folder
            $total = (int) $db->getValue('SELECT COUNT(id) AS total FROM file WHERE originalFilename IN (' . implode(',', $originalFilenames) . ') AND statusId = 1 AND folderId ' . ($folderId == NULL ? '= NULL' : '= ' . (int) $folderId) . ' AND (userId = ' . (int)$Auth->id.' OR file.uploadedUserId = '.(int)$Auth->id.')');
            if ($total > 0)
            {
                $result['error'] = true;
                $result['msg']   = t("items_with_same_name_in_folder", "There are already [[[TOTAL_SAME]]] file(s) with the same filename in that folder. Files can not be moved.", array('TOTAL_SAME' => $total));
            }
            else
            {
                $db->query('UPDATE file SET folderId ' . ($folderId == NULL ? '= NULL' : '= ' . (int) $folderId) . ' WHERE id IN (' . implode(',', $filteredIds) . ') AND (userId = ' . (int)$Auth->id.' OR file.uploadedUserId = '.(int)$Auth->id.')');
            }
        }
    }
}

echo json_encode($result);
exit;
