<?php
define('ADMIN_IGNORE_LOGIN', true);
include_once('_local_auth.inc.php');
include_once('_header_login.inc.php');

// check for mcrypt, required for login
if(!function_exists('mcrypt_create_iv'))
{
    adminFunctions::setError(t("mcrypt_not_found", "Mcypt functions not found within PHP, please ask support to install and try again."));
}
?>

<body class="login">
    <div>
        <div class="login_wrapper">
            <div class="animate form login_form">
                <section class="login_content">
                    <form method="POST" action="index.php">
                        <h1><?php echo UCWords(adminFunctions::t("admin_login", "admin login")); ?></h1>

                        <?php
                        if($_REQUEST['error'])
                        {
                            adminFunctions::setError("Incorrect login details or your login has expired, please try again.");
                        }
                        echo adminFunctions::compileErrorHtml();
                        ?>

                        <div>
                            <input name="username" type="text" class="form-control" placeholder="<?php echo adminFunctions::t("username", "username"); ?>" required="" autofocus=""/>
                        </div>
                        <div>
                            <input name="password" type="password" class="form-control" placeholder="<?php echo adminFunctions::t("password", "password"); ?>" required="" />
                        </div>
                        <div>
                            <button type="submit" value="<?php echo adminFunctions::t("login", "login"); ?>" class="btn btn-default submit"><?php echo adminFunctions::t("login", "login"); ?></button>
                            <a href="<?php echo WEB_ROOT . '/forgot_password.html'; ?>"><?php echo UCWords(t("forgot_password", "forgot password")); ?>?</a>
                        </div>

                        <div class="clearfix"></div>

                        <div class="separator">
                            <p class="change_link"><?php echo adminFunctions::t('admin_login_all_logins_records', 'All logins are recorded. Your IP address: [[[IP_ADDRESS]]].', array('IP_ADDRESS' => adminFunctions::getUsersIPAddress())); ?></p>
                            <div class="clearfix"></div>
                            <div>
                                <p>&copy; <?php echo date('Y'); ?> <?php echo adminFunctions::makeSafe(SITE_CONFIG_SITE_NAME); ?>. <?php echo adminFunctions::t('admin_login_all_rights_reserved', 'All Rights Reserved'); ?>.</p>
                            </div>
                        </div>

                        <input id="submitme" name="submitme" value="1" type="hidden"/>
                        <input id="version" name="version" value="<?php echo adminFunctions::makeSafe(_CONFIG_SCRIPT_VERSION); ?>" type="hidden"/>
                    </form>
                </section>
            </div>
        </div>
    </div>
</body>

<?php
include_once('_footer_login.inc.php');
?>