

<?php
// get packages
$packages = $db->getRows('SELECT id, level_id, label, level_type, max_storage_bytes FROM user_level WHERE on_upgrade_page = 1 ORDER BY level_type=\'free\' DESC, level_type=\'paid\' DESC, id ASC');
if ((!$packages) || COUNT($packages) == 0) {
    if (CURRENT_PAGE_KEY != 'index') {
        echo '<p>ERROR: No packages found, please contact the support team. (at least 1 package needs to have the option of \'On Upgrade Page\' to \'Yes\')</p>';
    }
} else {
   
    $colSize = floor(12 / COUNT($packages));
    $foundPaid = false;
    $tracker = 0;
    foreach ($packages AS $k => $package) {
        $mostPopular = false;
        if ($tracker == 1) {
            $mostPopular = true;
        }

        $boxClass = ' panel-blue';
        $boxAddText = '';
        $boxButtonClass = '';
        if ($mostPopular == true) {
            $boxClass = ' best-price panel-green';
            $boxAddText = '<span>' . t('most_popular', 'Most Popular') . '</span>';
            $boxButtonClass = ' bgcolor border-color';
        }

        // prepare package limits for later
        $hdStorage = (int) $package['max_storage_bytes'] == 0 ? UCWords(t('unlimited', 'unlimited')) : coreFunctions::formatSize($package['max_storage_bytes']);

        $footerContent = '';
        $pricePerMonth = '';
        $featuresHtml = '';
        $prices = array();
        switch ($package['level_id']) {
            case 'free':
                $pricePerMonth = strtoupper(t('free', 'free'));
                $featuresHtml = '<li class="list-group-item"><i class="fa fa-hdd-o"></i> ' . $hdStorage . ' ' . t('storage', 'Storage') . '</li>';
                $featuresHtml .= '<li class="list-group-item"><i class="fa fa-user"></i> ' . t('unique_members_area', 'Unique Members Area') . '</li>';
                $featuresHtml .= '<li class="list-group-item"><i class="fa fa-bullhorn"></i> ' . t('advert_supported', 'Advert Supported') . '</li>';

                // different button for logged in users
                if ($Auth->loggedIn()) {
                    $pricingButton = '<a href="' . coreFunctions::getCoreSitePath() . '/account_home.' . SITE_CONFIG_PAGE_EXTENSION . '" class="btn btn-danger btn-block btn-lg' . $boxButtonClass . '">' . strtoupper(t('your_account', 'Your Account')) . '</a>';
                } else {
                    $pricingButton = '<a href="' . coreFunctions::getCoreSitePath() . '/register.' . SITE_CONFIG_PAGE_EXTENSION . '" class="btn btn-danger btn-block btn-lg' . $boxButtonClass . '">' . strtoupper(t('register_now', 'Register Now')) . '</a>';
                }
                break;
            case '23':
                // load all prices
                $period = '1M';
                $prices = $db->getRows('SELECT id, pricing_label, period, price, package_pricing_type, download_allowance FROM user_level_pricing WHERE user_level_id = 23 ORDER BY price ASC');								

                if (COUNT($prices) > 0) {
                    // get lowest price
                    $lowest = null;
                    foreach ($prices AS $price) {
                        if ($lowest !== null) {
                            continue;
                        }
                        $lowest = $price['price'];
                        $period = $price['period'];
                    }
                    $pricePerMonth = $lowest;
                } else {
                    $pricePerMonth = strtoupper(t('free', 'free'));
                }

                $tracker++;
                if (CURRENT_PAGE_KEY == 'index') {
                    $pricingButton = '<a href="' . coreFunctions::getCoreSitePath() . '/upgrade.' . SITE_CONFIG_PAGE_EXTENSION . '?p=' . (int) $package['id'] . '" class="btn btn-danger btn-block btn-lg' . $boxButtonClass . '">' . strtoupper(t('upgrade_now', 'Upgrade Now'))
                            . '</a>';
                } else {
                    $pricingButton = '<a href="#" class="btn btn-danger btn-block btn-lg' . $boxButtonClass . '" data-toggle="modal" data-target="#pricing' . (int) $package['id'] . '">' . strtoupper(t('upgrade_now', 'Upgrade Now'))
                            . '</a>';
                }
                $foundPaid = true;

                $featuresHtml = '<li class="list-group-item"><i class="fa fa-hdd-o"></i> ' . $hdStorage . ' ' . t('storage', 'Storage') . '</li>';
                $featuresHtml .= '<li class="list-group-item"><i class="fa fa-user"></i> ' . t('unique_members_area', 'Unique Members Area') . '</li>';
                $featuresHtml .= '<li class="list-group-item"><i class="fa fa-check"></i> ' . t('advert_free', 'No Adverts') . '</li>';
                $featuresHtml .= '<li class="list-group-item"><i class="fa fa-lock"></i> ' . t('secure_payment', 'Secure Payment') . '</li>';
                $featuresHtml .= '<li class="list-group-item"><i class="fa fa-eye-slash"></i> ' . t('safe_and_anonymous', '100% Safe & Anonymous') . '</li>';
                if ($mostPopular == true) {
                    $featuresHtml .= '<li class="list-group-item"><i class="icon-star3"></i><i class="icon-star3"></i><i class="icon-star3"></i><i class="icon-star3"></i><i class="icon-star3"></i></li>';
                }
                break;
        }
        ?>

        <?php
        // output html for payment popup
        if ((COUNT($prices) > 0) && (CURRENT_PAGE_KEY != 'index')) {
            
            $pricingColSizePercent = floor(100 / COUNT($prices));
            $totalPercent = 0;
            foreach ($prices AS $k => $price) {
                // make sure the last column fills the remaining space
                if (($k + 1) == COUNT($prices)) {
                    $pricingColSizePercent = 100 - $totalPercent;
                }

                $priceStr = $price['price'];
                $days = coreFunctions::convertStringDatePeriodToDays($price['period']); // for older plugin gateway code
                ?>
               						
							      
							<div class="panel panel-success">             
							<div class="panel-heading">                
							<h3 class="text-center"><strong><?php echo validation::safeOutputToScreen($price['pricing_label']); ?></strong></h3>
							<p><strong>Content management with premier account and content security and workflow automation.</strong></p>     
							</div>					
							<div class="panel-body text-center">			
							<p class="lead total-price" style="font-size:40px"><strong><?php echo SITE_CONFIG_COST_CURRENCY_SYMBOL; ?><?php echo number_format(str_replace(",", "", $priceStr), 2); ?></strong></p>		
							<p class="lead price-per-day" style="font-size:16px"><?php echo ($pricePerMonth == strtoupper(t('free', 'free'))) ? $pricePerMonth : ('<span class="price-unit">' . SITE_CONFIG_COST_CURRENCY_SYMBOL . '</span>' . number_format(str_replace(",", "", $priceStr) / $days, 2) . '<span class="price-tenure"> Per Day</span>'); ?></p>	
							</div>					
							<ul class="list-group list-group-flush text-center">		
							<li class="list-group-item"><i class="fa fa-hdd-o"></i> <?php echo $hdStorage; ?></li>	
							<li class="list-group-item"><i class="fa fa-user"></i> <?php echo t('unique_members_area', 'Unique Members Area'); ?></li>
							<li class="list-group-item"><i class="fa fa-check"></i> <?php echo t('advert_free', 'No Adverts'); ?></li>		
							<li class="list-group-item"><i class="fa fa-lock"></i> <?php echo t('secure_payment', 'Secure Payment'); ?></li>
							<li class="list-group-item"><i class="fa fa-eye-slash"></i> <?php echo t('safe_and_anonymous', '100% Safe & Anonymous'); ?></li> 
							</ul>                
							<div class="panel-footer">        
							<?php                pluginHelper::outputPaymentLinks(array('days' => $days, 'price' => $price['price'], 'user_level_pricing_id' => $price['id'], 'user_level_package_id' => $package['id']));                ?>             
							</div>        
							</div>            
									
						
							
                <?php
                $totalPercent = $totalPercent + $pricingColSizePercent;
            }
           
        }
    }

   
}
