<?php

// local template functions

require_once(SITE_TEMPLATES_PATH . '/partial/_template_functions.inc.php');



// load theme functions

$themeObj = themeHelper::getLoadedInstance();

$themeSkin = $themeObj->getThemeSkin();

$homepageBackgroundImageUrl = $themeObj->getHomepageBackgroundImageUrl();

$homepageBackgroundVideoUrl = $themeObj->getHomepageBackgroundVideoUrl();



// top navigation

require_once(SITE_TEMPLATES_PATH . '/partial/_navigation_header.inc.php');

?>

<!DOCTYPE html>
<html lang="en" >
<head>

        <meta charset="utf-8">	
        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">

        <title><?php echo validation::safeOutputToScreen(PAGE_NAME); ?> - <?php echo validation::safeOutputToScreen(SITE_CONFIG_SITE_NAME); ?></title>

        <meta name="description" content="<?php echo validation::safeOutputToScreen(PAGE_DESCRIPTION); ?>" />

        <meta name="keywords" content="<?php echo validation::safeOutputToScreen(PAGE_KEYWORDS); ?>" />

        <meta name="copyright" content="Copyright &copy; <?php echo date("Y"); ?> - <?php echo validation::safeOutputToScreen(SITE_CONFIG_SITE_NAME); ?>" />

        <meta name="robots" content="index, follow" />
	   <meta name="revisit-after" content="3 days" />

        <?php pluginHelper::includeAppends('main_page_header.php', array('file' => (isset($file) ? $file : null), 'Auth' => $Auth)); ?>

        <meta property="og:image" content="<?php echo SITE_THEME_PATH; ?>/frontend_assets/images/icons/favicon/apple-touch-icon-114x114.png" />

        <link rel="icon" type="image/x-icon" href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/images/icons/favicon/favicon.ico" />

        <!-- Styles -->
           
		<!-- Bootstrap core CSS -->
  		<link rel="stylesheet" href="<?php echo SITE_THEME_PATH; ?>/sivt/css/bootstrap.css">        

		<!-- Bootstrap RTL 
  		<link rel="stylesheet" href="http://cdnjs.cloudflare.com/ajax/libs/bootstrap-rtl/3.2.0-rc2/css/bootstrap-rtl.css"> -->

		<!-- Font Awesome 4.1.0 -->
		<link href="http://netdna.bootstrapcdn.com/font-awesome/4.1.0/css/font-awesome.min.css" rel="stylesheet">

		<!-- SIVT Icons Font -->
		<link href="<?php echo SITE_THEME_PATH; ?>/sivt/css/sivt-font-styles.css" rel="stylesheet">

		<!-- SLIDER REVOLUTION 4.x CSS SETTINGS -->
		<link rel="stylesheet" type="text/css" href="<?php echo SITE_THEME_PATH; ?>/sivt/css/revolutionslider/settings.css" media="screen" />
    	
    	<!-- Animate CSS -->       
    	<link href="<?php echo SITE_THEME_PATH; ?>/sivt/css/themecss/animate.css" rel="stylesheet">

    	<!-- Lightbox CSS -->       
    	<link href="<?php echo SITE_THEME_PATH; ?>/sivt/css/themecss/lightbox.css" rel="stylesheet">
              
    	<!-- OWL Carousel -->       
    	<link href="<?php echo SITE_THEME_PATH; ?>/sivt/css/owl-carousel/owl.carousel.css" rel="stylesheet">
        <link href="<?php echo SITE_THEME_PATH; ?>/sivt/css/owl-carousel/owl.transitions.css" rel="stylesheet">

		<!-- Theme CSS -->
  		<link href="<?php echo SITE_THEME_PATH; ?>/sivt/css/sivt.css" rel="stylesheet">
		<link href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/css/custom.css" rel="stylesheet">
        
		<!-- Color CSS -->
		<link href="<?php echo SITE_THEME_PATH; ?>/sivt/css/colors/color-default.css" rel="stylesheet" title="style1">
   
	    <!-- Google Fonts -->
	    <link href='http://fonts.googleapis.com/css?family=Raleway:400,200,300,100,500,600,700,800,900' rel='stylesheet' type='text/css'>
        <link href='http://fonts.googleapis.com/css?family=Playball' rel='stylesheet' type='text/css'>

	    <!-- Fav and touch icons -->
        <link rel="apple-touch-icon-precomposed" sizes="144x144" href="<?php echo SITE_THEME_PATH; ?>/sivt/ico/apple-touch-icon-144-precomposed.png">
	    <link rel="apple-touch-icon-precomposed" sizes="114x114" href="<?php echo SITE_THEME_PATH; ?>/sivt/ico/apple-touch-icon-114-precomposed.png">
    	<link rel="apple-touch-icon-precomposed" sizes="72x72" href="<?php echo SITE_THEME_PATH; ?>/sivt/ico/apple-touch-icon-72-precomposed.png">
    	<link rel="apple-touch-icon-precomposed" href="<?php echo SITE_THEME_PATH; ?>/sivt/ico/apple-touch-icon-57-precomposed.png">
    	<link rel="shortcut icon" href="<?php echo SITE_THEME_PATH; ?>/sivt/ico/favicon.png">

        <!-- Social Share Icons -->

        <link rel="stylesheet" type="text/css" href="<?php echo SITE_THEME_PATH; ?>/frontend_assets/socialsider-v1.0/_css/socialsider-v1.0.css" media="all" />

        

        <script type="text/javascript">

            var WEB_ROOT = "<?php echo WEB_ROOT; ?>";

<?php echo translate::generateJSLanguageCode(); ?>

        </script>

        <?php

        // add js files, use the htmlHelper::addJsFile() function so files can be joined/minified

        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery-1.11.0.min.js');

        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery-ui.js');

        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.dataTables.min.js');

        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.tmpl.min.js');

        pluginHelper::addJsFile(SITE_JS_PATH . '/load-image.min.js');

        pluginHelper::addJsFile(SITE_JS_PATH . '/canvas-to-blob.min.js');

        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.iframe-transport.js');

        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.fileupload.js');

        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.fileupload-process.js');

        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.fileupload-resize.js');

        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.fileupload-validate.js');

        pluginHelper::addJsFile(SITE_JS_PATH . '/jquery.fileupload-ui.js');

        pluginHelper::addJsFile(SITE_JS_PATH . '/zeroClipboard/ZeroClipboard.js');

        pluginHelper::addJsFile(SITE_JS_PATH . '/global.js');



        // output js

        pluginHelper::outputJs();

        ?>

    </head>

   <body class="bg-pattern1" data-spy="scroll" data-target=".navbar">


<!-- Page Main Wrapper -->
<?php

		// adblock notification, if enabled via the site settings

		include_once(SITE_TEMPLATES_PATH . '/partial/_ad_block.inc.php');

		?>
	<div class="page-wrapper" data-spy="scroll"  id="page-top">

		<!-- Header Container -->
		<div class="header-wrapper">


			<!-- Header Main Container -->
   			<div class="header-main">

                <!-- Container -->
                <div class="container">
                    
                	<!-- Main Navigation & Logo -->                    
					<div class="main-navigation">
                    
                    	<div class="row">
                            
                            <!-- Main Navigation -->
                            <div class="col-md-12 columns">

								<nav class="navbar navbar-default gfx-mega nav-left" role="navigation">
									
                                    	
										<!-- Brand and toggle get grouped for better mobile display -->
										<div class="navbar-header">
											<a class="navbar-toggle" data-toggle="collapse" data-target="#gfx-collapse"></a>
                            				<div class="logo">
                           	    				<a href="<?php echo coreFunctions::getCoreSitePath(); ?>"><img src="<?php echo $themeObj->getMainLogoUrl(); ?>" alt="Logo"></a>
                                			</div>
										</div>

										<!-- Collect the nav links, forms, and other content for toggling -->
										<div class="collapse navbar-collapse" id="gfx-collapse">
											<ul class="nav navbar-nav gfx-nav">
												<li <?php echo (defined('CURRENT_PAGE_KEY') && CURRENT_PAGE_KEY == 'index') ? ' class="active"' : ''; ?>>
												  <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/index.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>">Home</a>	
												</li>
												<li <?php echo (defined('CURRENT_PAGE_KEY') && CURRENT_PAGE_KEY == 'search_files') ? ' class="active"' : ''; ?>>
												  <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/search.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>">Search Files <i class="fa fa-search iconright"></i></a>
												</li>
												<?php if($Auth->loggedIn()): ?>
												<li <?php echo (defined('CURRENT_PAGE_KEY') && CURRENT_PAGE_KEY == 'account_home') ? ' class="active"' : ''; ?>>
												  <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/account_home.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>">My Files</a>
												</li>
												<li <?php echo (defined('CURRENT_PAGE_KEY') && CURRENT_PAGE_KEY == 'settings') ? ' class="active"' : ''; ?>>
												  <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/account_edit.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>">My Account</a>
												</li>
												<?php endif; ?>
												<li <?php echo (defined('CURRENT_PAGE_KEY') && CURRENT_PAGE_KEY == 'upgrade') ? ' class="active"' : ''; ?>>
												  <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/upgrade.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>">Premium</a>
												</li>
												<?php if ($Auth->loggedIn() == false): ?>
                                                <li <?php echo (defined('CURRENT_PAGE_KEY') && CURRENT_PAGE_KEY == 'rewards') ? ' class="active"' : ''; ?>>
												  <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/plugins/rewards/site/rewards.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>">Rewards</a>
												</li>
												<?php endif; ?>
		                                        <?php if($Auth->loggedIn()): ?>
												<li <?php echo (defined('CURRENT_PAGE_KEY') && CURRENT_PAGE_KEY == 'rewards') ? ' class="active"' : ''; ?>>
												  <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/plugins/rewards/site/account_rewards.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>">Rewards</a>
												</li>
												<?php endif; ?>
												<li <?php echo (defined('CURRENT_PAGE_KEY') && CURRENT_PAGE_KEY == 'faq') ? ' class="active"' : ''; ?>>
												  <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/faq.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>">FAQ</a>
												</li>
												<?php if ($Auth->loggedIn() == false): ?>
												<li <?php echo (defined('CURRENT_PAGE_KEY') && CURRENT_PAGE_KEY == 'login') ? ' class="active"' : ''; ?>>
												  <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/login.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>">Sign In</a>
												</li>
                                                <li <?php echo (defined('CURRENT_PAGE_KEY') && CURRENT_PAGE_KEY == 'register') ? ' class="active"' : ''; ?>>
												  <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/register.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>" class="btn-danger">Sign Up</a>
												</li>
												<?php endif; ?>
												<?php if($Auth->loggedIn()): ?>
												 <li <?php echo (defined('CURRENT_PAGE_KEY') && CURRENT_PAGE_KEY == 'logout') ? ' class="active"' : ''; ?>>
												  <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/logout.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>" class="btn-danger">Log Out</a>
												</li>
												<?php endif; ?>
											</ul>
										</div><!-- /.navbar-collapse -->
									
								</nav>

                            </div>
                            <!-- /Main Navigation -->
                        
                        </div>              
                    
					</div>
                    <!-- /Main Navigation & Logo -->
                
                </div>
				<!-- /Container -->
   
		    </div>   
			<!-- /Header Main Container -->

		</div>

        <?php

        // if we're on the index page, show the uploader and slider

        if (defined('CURRENT_PAGE_KEY') && CURRENT_PAGE_KEY == 'index')

        {

            if (UserPeer::getAllowedToUpload() == true)

            {

                

                ?>


                <?php

            }

            ?>
<!-- Slider Container -->
		<div class="slider-wrapper">
<!-- START REVOLUTION SLIDER 3.1 rev5 fullwidth mode -->

	<div class="tp-banner-container">
		<div class="tp-banner" >
			<ul>
				
				<!-- SLIDE  -->
				<li data-transition="slidehorizontal" data-slotamount="1" data-masterspeed="1000" data-fstransition="fade" data-fsmasterspeed="1000" data-fsslotamount="7" data-saveperformance="off"  data-title="Upload">
					<!-- MAIN IMAGE -->
					<img src="<?php echo SITE_THEME_PATH; ?>/sivt/img/demo/slider/revolution-slider1.jpg"  alt="slidebg1"  data-bgfit="cover" data-bgposition="center top" data-bgrepeat="no-repeat">

					<div class="tp-caption large_bold_white customin customout tp-resizeme "
						data-x="center"
						data-y="150"

						
						
						data-start="1"
						
						data-customin="x:0;y:-20;z:0;rotationX:90;rotationY:0;rotationZ:0;scaleX:1;scaleY:1;skewX:0;skewY:0;opacity:0;transformPerspective:600;transformOrigin:50% 50%;"

						
						data-endelementdelay="0"
						data-customout="x:0;y:0;z:0;rotationX:0;rotationY:0;rotationZ:0;scaleX:10;scaleY:10;skewX:0;skewY:0;opacity:0;transformPerspective:600;transformOrigin:50% 50%;"
						
						data-captionhidden="on"
						style="font-size:90px;line-height:110px;">iBlaze Driver
					</div>

					<div class="tp-caption mediumlarge_light_white script-font customin customout tp-resizeme "
						data-x="center"
						data-y="280"

						
						
						data-start="1"
						
						data-customin="x:0;y:0;z:0;rotationX:0;rotationY:0;rotationZ:0;scaleX:1;scaleY:1;skewX:0;skewY:0;opacity:0;transformPerspective:600;transformOrigin:50% 50%;"
						data-endelementdelay="0.1"
						data-customout="x:-230;y:-20;z:0;rotationX:0;rotationY:0;rotationZ:90;scaleX:0.2;scaleY:0;skewX:0;skewY:0;opacity:0;transformPerspective:600;transformOrigin:50% 50%"
						
						data-captionhidden="on"
						style="z-index: 4; font-size:52px;">Upload & Share For Free
					</div>

					<div class="tp-caption  sfb"
						data-x="center"
						data-y="380"
						
						data-start="1"
						
						
						data-captionhidden="off"
						style="z-index: 6">
						<?php if($Auth->loggedIn()): ?>
                        <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/account_home.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>"><i class="livicon" data-n="cloud-up" data-s="150" data-color="#F7505A" data-hovercolor="#F7505A" data-op="1" data-onparent="true"></i></a>
					    <?php endif; ?>
						<?php if ($Auth->loggedIn() == false): ?>
						<a href="<?php echo coreFunctions::getCoreSitePath(); ?>/register.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>"><i class="livicon" data-n="cloud-up" data-s="150" data-color="#F7505A" data-hovercolor="#F7505A" data-op="1" data-onparent="true"></i></a>
						<?php endif; ?>
					</div>
					<div class="tp-caption"
						data-x="center"
						data-y="510"
						
						data-start="1"
						
						
						data-captionhidden="off"
						style="z-index: 6; font-size:32px;">
                         Drag & Drop Here or Click To Upload 
					</div>

				</li>


				<!-- SLIDE  -->
				<li data-transition="slidehorizontal" data-slotamount="1" data-masterspeed="1000" data-fstransition="fade" data-fsmasterspeed="1000" data-fsslotamount="7" data-saveperformance="off"  data-title="Amazing Features">
					<!-- MAIN IMAGE -->
					<img src="<?php echo SITE_THEME_PATH; ?>/sivt/img/demo/slider/revolution-slider2.jpg"  alt="slidebg2" data-bgfit="cover" data-bgposition="center center" data-bgrepeat="no-repeat">

					<div class="tp-caption large_bold_white customin customout "
						data-x="center"
						data-y="150"

						
						
						data-start="1"
						
						
						data-customin="x:0;y:0;z:0;rotationX:0;rotationY:0;rotationZ:0;scaleX:6;scaleY:6;skewX:0;skewY:0;opacity:0;transformPerspective:600;transformOrigin:50% 50%;"

					
						
						data-customout="x:0;y:0;z:0;rotationX:0;rotationY:0;rotationZ:0;scaleX:10;scaleY:10;skewX:0;skewY:0;opacity:0;transformPerspective:600;transformOrigin:50% 50%;"
						
						
						data-captionhidden="on"
						style="font-size:90px;line-height:110px;">iBlaze Driver
					</div>
                    
					<div class="tp-caption mediumlarge_light_white script-font customin customout "
						data-x="center"
						data-y="280"
						
						
						data-start="1"
						
						data-customin="x:0;y:0;z:0;rotationX:90;rotationY:0;rotationZ:0;scaleX:1;scaleY:1;skewX:0;skewY:0;opacity:1;transformPerspective:300;transformOrigin:50% 0%;"
						
						data-customout="x:0;y:0;z:0;rotationX:0;rotationY:0;rotationZ:0;scaleX:0;scaleY:0;skewX:0;skewY:0;opacity:0;transformPerspective:600;transformOrigin:50% 50%;"
						
						data-captionhidden="on"
						style="z-index: 4; font-size:52px;">Upload & Share For Free
					</div>

					<div class="tp-caption sfb "
						data-x="center"
						data-y="380"
						
						data-start="1"
					
						data-captionhidden="off"
						style="z-index: 6">
                       <?php if($Auth->loggedIn()): ?>
                        <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/account_home.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>"><i class="livicon" data-n="cloud-up" data-s="150" data-color="#F7505A" data-hovercolor="#F7505A" data-op="1" data-onparent="true"></i></a>
					    <?php endif; ?>
						<?php if ($Auth->loggedIn() == false): ?>
						<a href="<?php echo coreFunctions::getCoreSitePath(); ?>/register.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>"><i class="livicon" data-n="cloud-up" data-s="150" data-color="#F7505A" data-hovercolor="#F7505A" data-op="1" data-onparent="true"></i></a>
						<?php endif; ?>
					</div>
					<div class="tp-caption"
						data-x="center"
						data-y="510"
						
						data-start="1"
						
						
						data-captionhidden="off"
						style="z-index: 6; font-size:32px;">
                         Drag & Drop Here or Click To Upload 
					</div>
                    
				</li>
                <!-- SLIDE  -->

				
				<!-- SLIDE  -->
				<li data-transition="slidehorizontal" data-slotamount="1" data-masterspeed="1000" data-fstransition="fade" data-fsmasterspeed="1000" data-fsslotamount="7" data-saveperformance="off"  data-title="Amazing Features">
					<!-- MAIN IMAGE -->
					<img src="<?php echo SITE_THEME_PATH; ?>/sivt/img/demo/slider/simple-slider1.jpg"  alt="slidebg2" data-bgfit="cover" data-bgposition="center center" data-bgrepeat="no-repeat">

					<div class="tp-caption large_bold_white customin customout "
						data-x="center"
						data-y="150"

						
						
						data-start="1"
						
						
						data-customin="x:0;y:0;z:0;rotationX:0;rotationY:0;rotationZ:0;scaleX:6;scaleY:6;skewX:0;skewY:0;opacity:0;transformPerspective:600;transformOrigin:50% 50%;"

					
						
						data-customout="x:0;y:0;z:0;rotationX:0;rotationY:0;rotationZ:0;scaleX:10;scaleY:10;skewX:0;skewY:0;opacity:0;transformPerspective:600;transformOrigin:50% 50%;"
						
						
						data-captionhidden="on"
						style="font-size:90px;line-height:110px;">iBlaze Driver
					</div>
                    
					<div class="tp-caption mediumlarge_light_white script-font customin customout "
						data-x="center"
						data-y="280"
						
						
						data-start="1"
						
						data-customin="x:0;y:0;z:0;rotationX:90;rotationY:0;rotationZ:0;scaleX:1;scaleY:1;skewX:0;skewY:0;opacity:1;transformPerspective:300;transformOrigin:50% 0%;"
						
						data-customout="x:0;y:0;z:0;rotationX:0;rotationY:0;rotationZ:0;scaleX:0;scaleY:0;skewX:0;skewY:0;opacity:0;transformPerspective:600;transformOrigin:50% 50%;"
						
						data-captionhidden="on"
						style="z-index: 4; font-size:52px;">Upload & Share For Free
					</div>

					<div class="tp-caption sfb "
						data-x="center"
						data-y="380"
						
						data-start="1"
					
						data-captionhidden="off"
						style="z-index: 6">
                        <?php if($Auth->loggedIn()): ?>
                        <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/account_home.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>"><i class="livicon" data-n="cloud-up" data-s="150" data-color="#F7505A" data-hovercolor="#F7505A" data-op="1" data-onparent="true"></i></a>
					    <?php endif; ?>
						<?php if ($Auth->loggedIn() == false): ?>
						<a href="<?php echo coreFunctions::getCoreSitePath(); ?>/register.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>"><i class="livicon" data-n="cloud-up" data-s="150" data-color="#F7505A" data-hovercolor="#F7505A" data-op="1" data-onparent="true"></i></a>
						<?php endif; ?>
					</div>
					<div class="tp-caption"
						data-x="center"
						data-y="510"
						
						data-start="1"
						
						
						data-captionhidden="off"
						style="z-index: 6; font-size:32px;">
                         Drag & Drop Here or Click To Upload 
					</div>
                    
				</li>
                <!-- SLIDE  -->
				
				<!-- SLIDE  -->
				<li data-transition="slidehorizontal" data-slotamount="1" data-masterspeed="1000" data-fstransition="fade" data-fsmasterspeed="1000" data-fsslotamount="7" data-saveperformance="off"  data-title="Amazing Features">
					<!-- MAIN IMAGE -->
					<img src="<?php echo SITE_THEME_PATH; ?>/sivt/img/demo/slider/simple-slider2.jpg"  alt="slidebg2" data-bgfit="cover" data-bgposition="center center" data-bgrepeat="no-repeat">

					<div class="tp-caption large_bold_white customin customout "
						data-x="center"
						data-y="150"

						
						
						data-start="1"
						
						
						data-customin="x:0;y:0;z:0;rotationX:0;rotationY:0;rotationZ:0;scaleX:6;scaleY:6;skewX:0;skewY:0;opacity:0;transformPerspective:600;transformOrigin:50% 50%;"

					
						
						data-customout="x:0;y:0;z:0;rotationX:0;rotationY:0;rotationZ:0;scaleX:10;scaleY:10;skewX:0;skewY:0;opacity:0;transformPerspective:600;transformOrigin:50% 50%;"
						
						
						data-captionhidden="on"
						style="font-size:90px;line-height:110px;">iBlaze Driver
					</div>
                    
					<div class="tp-caption mediumlarge_light_white script-font customin customout "
						data-x="center"
						data-y="280"
						
						
						data-start="1"
						
						data-customin="x:0;y:0;z:0;rotationX:90;rotationY:0;rotationZ:0;scaleX:1;scaleY:1;skewX:0;skewY:0;opacity:1;transformPerspective:300;transformOrigin:50% 0%;"
						
						data-customout="x:0;y:0;z:0;rotationX:0;rotationY:0;rotationZ:0;scaleX:0;scaleY:0;skewX:0;skewY:0;opacity:0;transformPerspective:600;transformOrigin:50% 50%;"
						
						data-captionhidden="on"
						style="z-index: 4; font-size:52px;">Upload & Share For Free
					</div>

					<div class="tp-caption sfb "
						data-x="center"
						data-y="380"
						
						data-start="1"
					
						data-captionhidden="off"
						style="z-index: 6">
                       <?php if($Auth->loggedIn()): ?>
                        <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/account_home.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>"><i class="livicon" data-n="cloud-up" data-s="150" data-color="#F7505A" data-hovercolor="#F7505A" data-op="1" data-onparent="true"></i></a>
					    <?php endif; ?>
						<?php if ($Auth->loggedIn() == false): ?>
						<a href="<?php echo coreFunctions::getCoreSitePath(); ?>/register.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>"><i class="livicon" data-n="cloud-up" data-s="150" data-color="#F7505A" data-hovercolor="#F7505A" data-op="1" data-onparent="true"></i></a>
						<?php endif; ?>
					</div>
					<div class="tp-caption"
						data-x="center"
						data-y="510"
						
						data-start="1"
						
						
						data-captionhidden="off"
						style="z-index: 6; font-size:32px;">
                         Drag & Drop Here or Click To Upload 
					</div>
                    
				</li>
                <!-- SLIDE  -->
				
				<!-- SLIDE  -->
				<li data-transition="slidehorizontal" data-slotamount="1" data-masterspeed="1000" data-fstransition="fade" data-fsmasterspeed="1000" data-fsslotamount="7" data-saveperformance="off"  data-title="Amazing Features">
					<!-- MAIN IMAGE -->
					<img src="<?php echo SITE_THEME_PATH; ?>/sivt/img/demo/slider/simple-slider3.jpg"  alt="slidebg2" data-bgfit="cover" data-bgposition="center center" data-bgrepeat="no-repeat">

					<div class="tp-caption large_bold_white customin customout "
						data-x="center"
						data-y="150"

						
						
						data-start="1"
						
						
						data-customin="x:0;y:0;z:0;rotationX:0;rotationY:0;rotationZ:0;scaleX:6;scaleY:6;skewX:0;skewY:0;opacity:0;transformPerspective:600;transformOrigin:50% 50%;"

					
						
						data-customout="x:0;y:0;z:0;rotationX:0;rotationY:0;rotationZ:0;scaleX:10;scaleY:10;skewX:0;skewY:0;opacity:0;transformPerspective:600;transformOrigin:50% 50%;"
						
						
						data-captionhidden="on"
						style="font-size:90px;line-height:110px;">iBlaze Driver
					</div>
                    
					<div class="tp-caption mediumlarge_light_white script-font customin customout "
						data-x="center"
						data-y="280"
						
						
						data-start="1"
						
						data-customin="x:0;y:0;z:0;rotationX:90;rotationY:0;rotationZ:0;scaleX:1;scaleY:1;skewX:0;skewY:0;opacity:1;transformPerspective:300;transformOrigin:50% 0%;"
						
						data-customout="x:0;y:0;z:0;rotationX:0;rotationY:0;rotationZ:0;scaleX:0;scaleY:0;skewX:0;skewY:0;opacity:0;transformPerspective:600;transformOrigin:50% 50%;"
						
						data-captionhidden="on"
						style="z-index: 4; font-size:52px;">Upload & Share For Free
					</div>

					<div class="tp-caption sfb "
						data-x="center"
						data-y="380"
						
						data-start="1"
					
						data-captionhidden="off"
						style="z-index: 6">
                        <?php if($Auth->loggedIn()): ?>
                        <a href="<?php echo coreFunctions::getCoreSitePath(); ?>/account_home.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>"><i class="livicon" data-n="cloud-up" data-s="150" data-color="#F7505A" data-hovercolor="#F7505A" data-op="1" data-onparent="true"></i></a>
					    <?php endif; ?>
						<?php if ($Auth->loggedIn() == false): ?>
						<a href="<?php echo coreFunctions::getCoreSitePath(); ?>/register.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>"><i class="livicon" data-n="cloud-up" data-s="150" data-color="#F7505A" data-hovercolor="#F7505A" data-op="1" data-onparent="true"></i></a>
						<?php endif; ?>
					</div>
					<div class="tp-caption"
						data-x="center"
						data-y="510"
						
						data-start="1"
						
						
						data-captionhidden="off"
						style="z-index: 6; font-size:32px;">
                         Drag & Drop Here or Click To Upload 
					</div>
                    
				</li>
                <!-- SLIDE  -->
                
				<div class="tp-bannertimer tp-bottom"></div>
                
			</ul>
		</div>
	</div>
</div>

			<!-- END REVOLUTION SLIDER -->
    
            <?php

        }

        ?>

        <?php

        // if not index page

        if (!defined('CURRENT_PAGE_KEY') || CURRENT_PAGE_KEY != 'index'):

            ?>

            

            <!-- social slider -->

            <div class="reponsiveMobileHide socialsider socialsider_right_middle socialsider_fixed socialsider_bgcolor_white socialsider_opacity">

                <ul>

                    <li><a data-socialsider="facebook" target="_blank" href="http://www.facebook.com/sharer/sharer.php?u=<?php echo WEB_ROOT; ?>" title="Facebook"></a></li>

                    <li><a data-socialsider="twitter" target="_blank" href="https://twitter.com/share?url=<?php echo WEB_ROOT; ?>" title="Twitter"></a></li>

                    <li><a data-socialsider="google" target="_blank" href="https://plus.google.com/share?url=<?php echo WEB_ROOT; ?>" title="Google"></a></li>

                    <li><a data-socialsider="linkedin" target="_blank" href="https://www.linkedin.com/cws/share?url=<?php echo WEB_ROOT; ?>" title="Linkedin"></a></li>

                    <li><a data-socialsider="reddit" target="_blank" href="http://www.reddit.com/submit?url=<?php echo WEB_ROOT; ?>&title=<?php echo SITE_CONFIG_SITE_NAME; ?>" title="Reddit"></a></li>

                    <li><a data-socialsider="pinterest" target="_blank" href="https://pinterest.com/pin/create/bookmarklet/?media=<?php echo SITE_THEME_PATH; ?>/frontend_assets/images/icons/favicon/apple-touch-icon-114x114.png&url=<?php echo WEB_ROOT; ?>" title="Pinterest"></a></li>

                </ul>

            </div>

            <!-- end social slider -->

            

                    <?php endif; ?>
					<!-- Main Container -->
		<div class="main-wrapper">

        	<!-- Container -->
            <div class="container">