<?php

// require login
$Auth->requireUser(WEB_ROOT . '/login.' . SITE_CONFIG_PAGE_EXTENSION);

// setup database
$db = Database::getDatabase(true);

// load folder structure as array
$folderListing = fileFolder::loadAllForSelect($Auth->id);

// initial parent folder
$parentId = '-1';
if(isset($_REQUEST['parentId']))
{
    $parentId = (int)$_REQUEST['parentId'];
}

// defaults
$isPublic = 1;

$editFolderId = null;
$accessPassword = null;
if((int)$_REQUEST['editFolderId'])
{
    // load existing folder data
    $fileFolder = fileFolder::loadById((int)$_REQUEST['editFolderId']);
    if ($fileFolder)
    {
        // check current user has permission to edit the fileFolder
        if ($fileFolder->userId == $Auth->id)
        {
            // setup edit folder
            $editFolderId = $fileFolder->id;
            $folderName = $fileFolder->folderName;
            $parentId = $fileFolder->parentId;
            $isPublic = $fileFolder->isPublic;
            $accessPassword = $fileFolder->accessPassword;
        }
    }
}

?>

<form action="<?php echo WEB_ROOT; ?>/ajax/_account_add_edit_folder.process.ajax.php" autocomplete="off">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h4 class="modal-title"><?php echo $editFolderId==null?t("add_folder", "add folder"):(t("edit_existing_folder", "Edit Existing Folder").' ('.validation::safeOutputToScreen($fileFolder->folderName).')'); ?></h4>
    </div>

    <div class="modal-body">
        
        <?php if($editFolderId !== null): ?>
        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <label for="folderName" class="control-label"><?php echo t('edit_folder_sharing_url', 'Sharing Url:'); ?></label>
                    <div class="input-group">
                        <input type="text" class="form-control" value="<?php echo validation::safeOutputToScreen(WEB_ROOT.'/'.$editFolderId.'~f'); ?>" readonly/>
                        <span class="input-group-btn">
                            <button type="button" class="btn btn-primary" onClick="window.open('<?php echo validation::safeOutputToScreen(WEB_ROOT.'/'.$editFolderId.'~f'); ?>'); return false;"><i class="entypo-link"></i></button>
                        </span>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
        
        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <label for="folderName" class="control-label"><?php echo t("edit_folder_name", "Folder Name:"); ?></label>
                    <input type="text" class="form-control" name="folderName" id="folderName" value="<?php echo isset($folderName) ? validation::safeOutputToScreen($folderName) : ''; ?>"/>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <label for="parentId" class="control-label"><?php echo t('edit_folder_parent_folder', 'Parent Folder:'); ?></label>
                    <select class="form-control" name="parentId" id="parentId">
                        <option value="-1"><?php echo t('_none_', '- none -'); ?></option>
                        <?php
                        $currentFolderStr = $editFolderId!==null?$folderListing[$editFolderId]:0;
                        foreach ($folderListing AS $k => $folderListingItem)
                        {
                            if($editFolderId !== null)
                            {
                                // ignore this folder and any children
                                if(substr($folderListingItem, 0, strlen($currentFolderStr)) == $currentFolderStr)
                                {
                                    continue;
                                }
                            }
                            
                            echo '<option value="' . (int) $k . '"';
                            if ($parentId == (int) $k)
                            {
                                echo ' SELECTED';
                            }
                            echo '>' . validation::safeOutputToScreen($folderListingItem) . '</option>';
                        }
                        ?>
                    </select>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="isPublic" class="control-label"><?php echo t('edit_folder_is_public', 'Public:'); ?></label>
                    <select class="form-control" name="isPublic" id="isPublic">
                        <option value="0" <?php echo $isPublic == 0 ? 'SELECTED' : ''; ?>><?php echo t('no_keep_private', 'No, keep private'); ?></option>
                        <option value="1" <?php echo $isPublic == 1 ? 'SELECTED' : ''; ?>><?php echo t('yes_allow_public', 'Yes, allow sharing'); ?></option>
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="accessPassword" class="control-label"><?php echo t("edit_folder_optional_password", "Optional Password:"); ?></label>
                    <div class="row">
                        <div class="col-md-2 inline-checkbox">
                            <input type="checkbox" name="enablePassword" id="enablePassword" value="1" <?php echo strlen($accessPassword)?'CHECKED':''; ?> onClick="toggleFolderPasswordField();">
                        </div>
                        <div class="col-md-10">
                            <input type="password" class="form-control" name="password" id="password" autocomplete="off"<?php echo strlen($accessPassword)?' value="**********"':''; ?> <?php echo strlen($accessPassword)?'':'READONLY'; ?>/>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal-footer">
        <input type="hidden" name="submitme" id="submitme" value="1"/>
        <?php if($editFolderId !== null): ?>
        <input type="hidden" value="<?php echo (int) $editFolderId; ?>" name="editFolderId"/>
        <?php endif; ?>
        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo t("cancel", "cancel"); ?></button>
        <button type="button" class="btn btn-info" onClick="processAjaxForm(this, function() { refreshFolderListing(); $('.modal').modal('hide'); updateStatsViaAjax(); }); return false;"><?php echo $editFolderId==null?t("add_folder", "add folder"):t("update_folder", "update folder"); ?> <i class="entypo-check"></i></button>
    </div>
</form>