<?php

require_once('../../../core/includes/master.inc.php');
use Omnipay\Omnipay;

// load plugin details
$pluginConfig = pluginHelper::pluginSpecificConfiguration('payment');
$pluginSettings = $pluginConfig['data']['plugin_settings'];

if(!isset($_REQUEST['user_level_pricing_id']))
{
    coreFunctions::redirect(WEB_ROOT . '/index.html');
}

if(!isset($_REQUEST['cid']))
{
    coreFunctions::redirect(WEB_ROOT . '/index.html');
}

// require login
if(!isset($_REQUEST['i']))
{
    $Auth->requireUser(WEB_ROOT . '/register.' . SITE_CONFIG_PAGE_EXTENSION);
    $userId = $Auth->id;
    $username = $Auth->username;
    $userEmail = $Auth->email;
}
else
{
    $user = UserPeer::loadUserByIdentifier($_REQUEST['i']);
    if(!$user)
    {
        die('User not found!');
    }

    $userId = $user->id;
    $username = $user->username;
    $userEmail = $user->email;
}

$user_level_pricing_id = (int) $_REQUEST['user_level_pricing_id'];

$fileId = null;
if(isset($_REQUEST['f']))
{
    $file = file::loadByShortUrl($_REQUEST['f']);
    if($file)
    {
        $fileId = $file->id;
    }
}

// load the payment gateway data
$gatewayParams = $db->getRow('SELECT plugin_payment_gateways_configured.params, plugin_payment_gateways.class_name FROM plugin_payment_gateways_configured '
        . 'LEFT JOIN plugin_payment_gateways ON plugin_payment_gateways_configured.gateway_id = plugin_payment_gateways.id '
        . 'WHERE plugin_payment_gateways_configured.id = '.(int)$_REQUEST['cid'].' LIMIT 1');
if(!$gatewayParams)
{
    coreFunctions::redirect(WEB_ROOT . '/index.html');
}

// create order entry
$order = OrderPeer::createByPackageId($userId, $user_level_pricing_id, $fileId);
if($order)
{
    // prep params
    $gatewayParamsArr = json_decode($gatewayParams['params'], true);

    // setup the payment gateway object
    $gateway = Omnipay::create($gatewayParams['class_name']);
    foreach($gatewayParamsArr AS $k=>$gatewayParam) {
        $funcName = 'set'.ucfirst($k);
        if(method_exists($gateway, $funcName)) {
            $gateway->{$funcName}($gatewayParam);
        }
    }
    
    // Example form data
    $formData = [
        'number' => '4242424242424242',
        'expiryMonth' => '6',
        'expiryYear' => '2019',
        'cvv' => '123'
    ];
    
    // send purchase request
    try {
        $response = $gateway->purchase(
            [
                'amount' => $order->amount,
                'currency' => SITE_CONFIG_COST_CURRENCY_CODE,
                'card' => $formData
            ]
        )->send();
    } catch (\Exception $e) {
        // internal error, log exception and display a generic message to the customer
        exit('Error: '.$e->getMessage());
    }

    // Process response
    if ($response->isSuccessful()) {
        // Payment was successful
        print_r($response);
    } elseif ($response->isRedirect()) {
        // Redirect to offsite payment gateway
        $response->redirect();
    } else {
        // Payment failed
        echo $response->getMessage();
    }
}
