<?php

class pluginPayment extends Plugin
{

    public $config = null;

    public function __construct()
    {
        // get the plugin config
        include('_plugin_config.inc.php');

        // load config into the object
        $this->config = $pluginConfig;
    }

    public function getPluginDetails()
    {
        return $this->config;
    }
    
    public function install()
    {
        return parent::install();
    }

    public function getAvailableGateways() {
        // setup database
        $db = Database::getDatabase();
        
        // load gateways
        return $db->getRows('SELECT * FROM plugin_payment_gateways WHERE available = 1 ORDER BY label ASC');
    }
    
    public function getAvailableGatewayGroups() {
        // setup database
        $db = Database::getDatabase();
        
        // load gateways
        return $db->getRows('SELECT gateway_group, class_name, url FROM plugin_payment_gateways WHERE available = 1 GROUP BY gateway_group ORDER BY label ASC');
    }
    
    public function getEnabledGateways() {
        // setup database
        $db = Database::getDatabase();
        
        // load enabled gateways
        return $db->getRows('SELECT plugin_payment_gateways_configured.id AS config_id, plugin_payment_gateways.* FROM plugin_payment_gateways_configured '
                . 'LEFT JOIN plugin_payment_gateways ON plugin_payment_gateways_configured.gateway_id = plugin_payment_gateways.id '
                . 'WHERE plugin_payment_gateways_configured.status = "active" AND plugin_payment_gateways.available = 1 '
                . 'ORDER BY label ASC');
    }
}
