<?php

// includes and security
include_once('../../../../core/includes/master.inc.php');
include_once(DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');

$iDisplayLength = (int) $_REQUEST['iDisplayLength'];
$iDisplayStart  = (int) $_REQUEST['iDisplayStart'];
$sSortDir_0     = $_REQUEST['sSortDir_0'] ? $_REQUEST['sSortDir_0'] : "desc";

// get sorting columns
$iSortCol_0     = (int) $_REQUEST['iSortCol_0'];
$sColumns       = trim($_REQUEST['sColumns']);
$arrCols        = explode(",", $sColumns);
$sortColumnName = $arrCols[$iSortCol_0];
$sort           = 'plugin_payment_gateways.label';
switch ($sortColumnName)
{
    case 'date_created':
        $sort = 'date_created';
        break;
    case 'gateway':
        $sort = 'plugin_payment_gateways.label';
        break;
    case 'status':
        $sort = 'status';
        break;
}

$sqlClause = "WHERE 1=1 ";

$totalRS   = $db->getValue("SELECT COUNT(plugin_payment_gateways_configured.id) AS total FROM plugin_payment_gateways_configured LEFT JOIN plugin_payment_gateways ON plugin_payment_gateways_configured.gateway_id = plugin_payment_gateways.id " . $sqlClause);
$gatewayConfigs = $db->getRows("SELECT plugin_payment_gateways_configured.*, plugin_payment_gateways.label FROM plugin_payment_gateways_configured LEFT JOIN plugin_payment_gateways ON plugin_payment_gateways_configured.gateway_id = plugin_payment_gateways.id " . $sqlClause . " ORDER BY " . $sort . " " . $sSortDir_0 . " LIMIT " . $iDisplayStart . ", " . $iDisplayLength);

$data = array();
if (COUNT($gatewayConfigs) > 0)
{
    foreach ($gatewayConfigs AS $gatewayConfig)
    {
        $lRow = array();
        $lRow[] = '<img src="../assets/img/icons/16px.png" width="16" height="16" title="request" alt="gateway"/>';
        $lRow[] = '<a href="#" onClick="editGatewayForm('.(int)$gatewayConfig['id'].'); return false;">'.validation::safeOutputToScreen($gatewayConfig['label']).'</a>';
        $lRow[] = coreFunctions::formatDate($gatewayConfig['date_created'], SITE_CONFIG_DATE_TIME_FORMAT);
        $lRow[] = '<span class="statusText'.ucfirst($gatewayConfig['status']).'">'.validation::safeOutputToScreen($gatewayConfig['status']).'</span>';
	
        $links = array();
        $links[] = '<a href="#" onClick="editGatewayForm('.(int)$gatewayConfig['id'].'); return false;">edit</a>';
	$links[] = '<a href="'.PLUGIN_WEB_ROOT.'/payment/admin/gateway_manage.php?remove_gateway_config_id='.(int)$gatewayConfig['id'].'" onClick="return confirm(\'Are you sure you to remove this payment gateway configuration? Users on your site will no longer be able to submit payment using this payment method.\');">remove</a>';
        if($gatewayConfig['status'] === 'active') {
            $links[] = '<a href="'.PLUGIN_WEB_ROOT.'/payment/admin/gateway_manage.php?disable_gateway_config_id='.(int)$gatewayConfig['id'].'">disable</a>';
        }
        else {
            $links[] = '<a href="'.PLUGIN_WEB_ROOT.'/payment/admin/gateway_manage.php?enable_gateway_config_id='.(int)$gatewayConfig['id'].'">activate</a>';
        }
        $lRow[]  = implode(" | ", $links);

        $data[] = $lRow;
    }
}

$resultArr = array();
$resultArr["sEcho"]                = intval($_GET['sEcho']);
$resultArr["iTotalRecords"]        = (int) $totalRS;
$resultArr["iTotalDisplayRecords"] = $resultArr["iTotalRecords"];
$resultArr["aaData"]               = $data;

echo json_encode($resultArr);
