<?php

// includes and security
include_once('../../../../core/includes/master.inc.php');
include_once(DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');
use Omnipay\Omnipay;

// load our payment object for later
$pluginObj = pluginHelper::getInstance('payment');

// prepare result
$result = array();
$result['error'] = false;
$result['msg'] = '';

// load the gateway we're interested in
$gateway = $db->getRow('SELECT * FROM plugin_payment_gateways WHERE id = '.(int)$_REQUEST['selectedGateway'].' LIMIT 1');
if(!$gateway) {
    $result['msg'] = 'Failed load gateway, please try again later.';
    echo json_encode($result);
    exit;
}

// load our gateway object
$gatewayObj = Omnipay::create($gateway['class_name']);
$gatewayParams = $gatewayObj->getParameters();

// is this an edit?
$gatewaySettings = null;
if((isset($_REQUEST['gEditGatewayId'])) && ((int) $_REQUEST['gEditGatewayId'])) {
    $sQL = "SELECT * FROM plugin_payment_gateways_configured WHERE id=" . (int)$_REQUEST['gEditGatewayId'] ." LIMIT 1";
    $gatewayConfigDetails = $db->getRow($sQL);
    if($gatewayConfigDetails) {
        $gatewaySettings = json_decode($gatewayConfigDetails['params'], true);
    }
}

// is this an edit?
$fileServerId = null;

if(isset($_REQUEST['gEditFileServerId']))
{
    $fileServerId = (int) $_REQUEST['gEditFileServerId'];
    if($fileServerId)
    {
        $sQL = "SELECT * FROM file_server WHERE id=" . $fileServerId;
        $serverDetails = $db->getRow($sQL);
        if($serverDetails)
        {
            $server_label = $serverDetails['serverLabel'];
        }
    }
}

$result['html'] .= '    <div class="x_panel">
                            <div class="x_content">';
$result['html'] .= '            <p>Enter the details supplied by your gateway account in the fields below. Note that all fields may not be required by the payment gateway. More information on the Omnipay payment gateway API can be <a href="https://omnipay.thephpleague.com/gateways/official/" target="_blank">found here</a>.</p>';

$result['html'] .= '                    <div>';
$result['html'] .= '                        <label class="control-label col-md-3 col-sm-3 col-xs-12">&nbsp;</label>';
$result['html'] .= '                        <div class="col-md-9 col-sm-9 col-xs-12">';
$result['html'] .= '                        <a href="'.$gateway['url'].'" target="_blank" rel="nofollow" class="gateway"><img src="../assets/img/gateways/'.$gateway['class_name'].'/logo.jpg" alt="'.$gateway['gateway_group'].'" style="height: 70px;"/></a>';
$result['html'] .= '                        </div>';
$result['html'] .= '                    </div>';

$result['html'] .= '                    <div class="form-group">';
$result['html'] .= '                        <label class="control-label col-md-3 col-sm-3 col-xs-12">Gateway Website:</label>';
$result['html'] .= '                        <div class="col-md-9 col-sm-9 col-xs-12" style="padding-top: 7px;">';
$result['html'] .= '                        <a href="'.$gateway['url'].'" target="_blank" rel="nofollow" class="gateway">'.$gateway['url'].'</a>';
$result['html'] .= '                        </div>';
$result['html'] .= '                    </div>';

foreach($gatewayParams AS $label => $gatewayParam) {
    $labelFormatted = adminFunctions::convertCamelcaseToHuman($label);
    $value = '';
    if(isset($gatewaySettings[$label])) {
        $value = $gatewaySettings[$label];
    }
    $result['html'] .= '                    <div class="form-group">';
    $result['html'] .= '                        <label class="control-label col-md-3 col-sm-3 col-xs-12">'.$labelFormatted.':</label>';
    $result['html'] .= '                        <div class="col-md-9 col-sm-9 col-xs-12">';
    $result['html'] .= '                        <input type="text" name="gateway_settings['.$label.']" id="'.$label.'" class="form-control" value="'.validation::safeOutputToScreen($value).'"/>';
    $result['html'] .= '                        </div>';
    $result['html'] .= '                    </div>';
}

$result['html'] .= '        </div>';
$result['html'] .= '    </div>';

echo json_encode($result);
exit;
