<?php
// check for subtitles
$subtitleArr = $pluginObj->getSubtitlesForJWPlayer($originalFileObj);
?>
<div id="jwPlayerContainer">Loading media...</div>
<script type="text/javascript">
//<![CDATA[
$(document).ready(function() {
	<?php $downloadUrlForMedia = $childFileObj->generateDirectDownloadUrlForMedia(); ?>
	jwplayer("jwPlayerContainer").setup({
		file: "<?php echo $downloadUrlForMedia; ?>",
		type: "<?php echo $jwPlayerCat; ?>",
		title: "<?php echo validation::safeOutputToScreen($originalFileObj->originalFilename); ?>",
		width: "100%",
		startparam: "start",
		abouttext: '<?php echo str_replace("'", "\'", SITE_CONFIG_SITE_NAME); ?>',
		aboutlink: '<?php echo str_replace("'", "\'", $originalFileObj->getFullShortUrl()); ?>',
		sharing: {
		link: '<?php echo str_replace("'", "\'", $originalFileObj->getFullShortUrl()); ?>'
		},
		logo: {
		file: '<?php echo SITE_IMAGE_PATH; ?>/main_logo.jpg',
				link: '<?php echo coreFunctions::getCoreSitePath(); ?>',
				linktarget: '_blank',
				hide: 'false'
		},
		tracks: [<?php echo str_replace('\/', '/', implode(',', $subtitleArr)); ?>], <?php echo $pluginSettings['jwplayer_lights_out'] == 1 ? ("plugins: { '" . PLUGIN_WEB_ROOT . "/mediaplayer/assets/js/lightsout.js':{} },\n") : ''; ?>
		aspectratio: "16:9",
		image: "<?php echo file::getIconPreviewImageUrl((array)$childFileObj, false, 160, false, 640, 320); ?>"  
	});

	<?php if(!defined("FROM_USER_ACCOUNT")): ?>
	// track total played in seconds
	jwTimer = setInterval(trackJWPlayedTime, (timerPeriod*1000));
	<?php endif; ?>
});

<?php if(!defined("FROM_USER_ACCOUNT")): ?>
function trackJWPlayedTime()
{
	if(trackJWTime == false)
	{
		// stop any future attempts of the timer
		clearInterval(jwTimer);
		return false;
	}
	
	if(jwplayer("jwPlayerContainer").getState() == 'PLAYING')
	{
		// track actual played time
		totalPlayedTime = totalPlayedTime+timerPeriod;
	}

	if(mediaTotalDuration == -1)
	{
		// get total video length
		mediaTotalDuration = jwplayer("jwPlayerContainer").getDuration();
	}
	else
	{
		// calculate percentage
		percent = 0;
		if(totalPlayedTime > 0)
		{
			percent = (parseInt(totalPlayedTime)/parseInt(mediaTotalDuration))*100;
		}
		
		// should we log yet?
		if(percent >= ackPercentage)
		{
			// clear for next time
			trackJWTime = false;
			
			// log PPD
			$.ajax({
				method: "POST",
				url: "<?php echo PLUGIN_WEB_ROOT; ?>/rewards/site/_log_media_percentage.php",
				data: { fileId: "<?php echo $childFileObj->id; ?>", tracker: "<?php echo base64_encode($downloadUrlForMedia); ?>", percent: percent }
			});
		}
	}
}
<?php endif; ?>
//]]>
</script>