<?php

// global includes
require_once('../../../core/includes/master.inc.php');

// load plugin details
$pluginConfig   = pluginHelper::pluginSpecificConfiguration('stripe');
$pluginSettings = $pluginConfig['data']['plugin_settings'];
$settingsArr    = json_decode($pluginSettings, true);

// validate token with stripe
require_once('./lib/Stripe.php');
Stripe::setApiKey($settingsArr['secret_key']); // secret key

// retrieve the request's body and parse it as JSON
$body = @file_get_contents('php://input');
$event_json = json_decode($body);

if($event_json->type != 'charge.succeeded')
{
    die();
}

if($event_json->data->object->paid != 1)
{
    die();
}

$customerId = $event_json->data->object->card->customer;
$customerName = $event_json->data->object->card->name;
$amount = $event_json->data->object->amount/100;
$description = $event_json->data->object->statement_description;

// load user id
$userId = (int)$db->getValue('SELECT user_id FROM plugin_stripe_subscription WHERE stripe_customer_id = '.$db->quote($customerId).' LIMIT 1');
$periodDays = (int)$db->getValue('SELECT period_days FROM plugin_stripe_subscription WHERE stripe_customer_id = '.$db->quote($customerId).' LIMIT 1');
if($periodDays == 0)
{
    $periodDays = 30;
}

$dbInsert                 = new DBObject("payment_log", array("user_id", "date_created", "amount",
    "currency_code", "from_email", "to_email", "description",
    "request_log", "payment_method")
);
$dbInsert->user_id        = $userId;
$dbInsert->date_created   = date("Y-m-d H:i:s", time());
$dbInsert->amount         = $amount;
$dbInsert->currency_code  = SITE_CONFIG_COST_CURRENCY_CODE;
$dbInsert->from_email     = $customerName;
$dbInsert->to_email       = '';
$dbInsert->description    = $description;
$dbInsert->request_log    = print_r($event_json, true);
$dbInsert->payment_method = 'Stripe';
$dbInsert->insert();

// create & update order status to paid
$orderHash = MD5(time() . $userId);
$order     = OrderPeer::create($userId, $orderHash, $periodDays, $amount);

$dbUpdate               = new DBObject("premium_order", array("order_status"), 'id');
$dbUpdate->order_status = 'completed';
$dbUpdate->id           = $order->id;
$dbUpdate->update();

// extend/upgrade user
$rs = UserPeer::upgradeUser($userId, $periodDays + 3);
if ($rs === false)
{
    // failed to update user
    die();
}
