<?php

// global includes
require_once('../../../core/includes/master.inc.php');

// load plugin details
$pluginConfig   = pluginHelper::pluginSpecificConfiguration('stripe');
$pluginSettings = $pluginConfig['data']['plugin_settings'];
$settingsArr = json_decode($pluginSettings, true);

// get token
$token = trim($_REQUEST['token']);
$charge_days = trim($_REQUEST['charge_days']);
$charge_amount = str_replace(",", "", constant('SITE_CONFIG_COST_FOR_' . $charge_days . '_DAYS_PREMIUM')) * 100;
$fileId = null;
if (isset($_REQUEST['f']))
{
    $file = file::loadByShortUrl($_REQUEST['f']);
    if ($file)
    {
        $fileId = $file->id;
    }
}

// validate token with stripe
require_once('./lib/Stripe.php');
Stripe::setApiKey($settingsArr['secret_key']); // secret key
$rs = Stripe_Charge::create(array(
  "amount" => $charge_amount,
  "currency" => SITE_CONFIG_COST_CURRENCY_CODE,
  "card" => $token,
  "description" => $charge_days." days premium extension"
));

if(!$rs)
{
	// redirect back to payment failed page
	coreFunctions::redirect(WEB_ROOT.'/upgrade.'.SITE_CONFIG_PAGE_EXTENSION);
}

$rs = json_decode($rs);
if($rs->paid != 1)
{
	// redirect to payment failed page
	coreFunctions::redirect(WEB_ROOT.'/upgrade.'.SITE_CONFIG_PAGE_EXTENSION);
}

// check login
$Auth->requireUser(WEB_ROOT.'/login.'.SITE_CONFIG_PAGE_EXTENSION);

// payment done
$userId = $Auth->id;

$amount    = number_format(constant('SITE_CONFIG_COST_FOR_' . $charge_days . '_DAYS_PREMIUM'), 2);

$dbInsert                 = new DBObject("payment_log", array("user_id", "date_created", "amount",
	"currency_code", "from_email", "to_email", "description",
	"request_log", "payment_method")
);
$dbInsert->user_id        = $userId;
$dbInsert->date_created   = date("Y-m-d H:i:s", time());
$dbInsert->amount         = $amount;
$dbInsert->currency_code  = SITE_CONFIG_COST_CURRENCY_CODE;
$dbInsert->from_email     = $rs->card->name;
$dbInsert->to_email       = '';
$dbInsert->description    = $charge_days . ' days extension';
$dbInsert->request_log    = print_r($rs, true);
$dbInsert->payment_method = 'Stripe';
$dbInsert->insert();

// create & update order status to paid
$orderHash = MD5(time() . $userId);
$order     = OrderPeer::create($userId, $orderHash, $charge_days, $amount, $fileId);

$dbUpdate               = new DBObject("premium_order", array("order_status"), 'id');
$dbUpdate->order_status = 'completed';
$dbUpdate->id           = $order->id;
$dbUpdate->update();

// extend/upgrade user
$rs = UserPeer::upgradeUser($userId, $charge_days);
if ($rs === false)
{
	// failed to update user
	die();
}

// append any plugin includes
pluginHelper::includeAppends('payment_ipn_paypal.php');

// redirect to confirmation page
coreFunctions::redirect(WEB_ROOT.'/payment_complete.'.SITE_CONFIG_PAGE_EXTENSION);
