<?php

require_once('../../../core/includes/master.inc.php');
require_once('../bp_options.php');
require_once('../bp_lib.php');

// start logging
log::setContext('plugin_bitpay');
log::info('Received request on IPN for bitpay plugin. REQUEST: ' . print_r($_REQUEST, true));

// load plugin details
$pluginConfig   = pluginHelper::pluginSpecificConfiguration('bitpay');
$pluginSettings = $pluginConfig['data']['plugin_settings'];
$apiKey         = '';
if (strlen($pluginSettings))
{
    $pluginSettingsArr = json_decode($pluginSettings, true);
    $apiKey            = $pluginSettingsArr['api_key'];
}

$notice = bpVerifyNotification($apiKey);

if (isset($notice['error']))
{
    log::error('Could not verify IPN request with BitPay.');
    die;
}

$xTransId       = $notice['id'];
$paymentTracker = $notice['posData'][1];
$xAmount        = $notice['posData'][0];
if (in_array($notice['status'], array('complete', 'confirmed')))
{
    // load order using custom payment tracker hash
    $order = OrderPeer::loadByPaymentTracker($paymentTracker);
    if ($order)
    {
        $extendedDays  = $order->days;
        $userId        = $order->user_id;
        $upgradeUserId = $order->upgrade_user_id;
        $orderId       = $order->id;

        // log in payment_log
        $response_vars = "";
        foreach ($_REQUEST AS $k => $v)
        {
            $response_vars .= $k . " => " . $v . "\n";
        }
        $dbInsert                = new DBObject("payment_log", array("user_id", "date_created", "amount",
            "currency_code", "from_email", "to_email", "description",
            "request_log")
        );
        $dbInsert->user_id       = $userId;
        $dbInsert->date_created  = date("Y-m-d H:i:s", time());
        $dbInsert->amount        = $xAmount;
        $dbInsert->currency_code = 'BTC';
        $dbInsert->from_email    = '';
        $dbInsert->to_email      = '';
        $dbInsert->description   = $extendedDays . ' days extension';
        $dbInsert->request_log   = $response_vars;
        $dbInsert->insert();

        // make sure the amount paid matched what we expect
        //if ($xAmount != $order->amount)
        //{
        // order amounts did not match
        //    die();
        //}
        // make sure the order is pending
        if ($order->order_status == 'completed')
        {
            // order has already been completed
            log::warning('Order already set to complete on IPN callback.');
            die();
        }

        // update order status to paid
        $dbUpdate               = new DBObject("premium_order", array("order_status"), 'id');
        $dbUpdate->order_status = 'completed';
        $dbUpdate->id           = $orderId;
        $effectedRows           = $dbUpdate->update();
        if ($effectedRows === false)
        {
            // failed to update order
            log::error('Could not update original order on IPN callback.');
            die();
        }

        // extend/upgrade user
        $user          = UserPeer::loadUserById($userId);
        $newExpiryDate = strtotime('+' . $order->days . ' days');
        if (($user->level == 'paid user') || ($user->level == 'admin'))
        {
            // add onto existing period
            $existingExpiryDate = strtotime($user->paidExpiryDate);

            // if less than today just revert to now
            if ($existingExpiryDate < time())
            {
                $existingExpiryDate = time();
            }

            $newExpiryDate = (int) $existingExpiryDate + (int) ($order->days * (60 * 60 * 24));
        }

        $newUserType = 'paid user';
        if ($user->level == 'admin')
        {
            $newUserType = 'admin';
        }

        // update user account to premium
        $dbUpdate                 = new DBObject("users", array("level", "lastPayment", "paidExpiryDate"), 'id');
        $dbUpdate->level          = $newUserType;
        $dbUpdate->lastPayment    = date("Y-m-d H:i:s", time());
        $dbUpdate->paidExpiryDate = date("Y-m-d H:i:s", $newExpiryDate);
        $dbUpdate->id             = $userId;
        $effectedRows             = $dbUpdate->update();
        if ($effectedRows === false)
        {
            log::info('Failed to extend user account on IPN callback.');
            // failed to update user
            die();
        }

        // append any plugin includes
        pluginHelper::includeAppends('payment_ipn_paypal.php');
    }
    else
    {
        log::error('Failed loading original order in IPN callback.');
    }
}
else
{
    log::warning('IPN callback was not a status of complete or confirmed.');
}

log::breakInLogFile();
log::setContext('system');